/******************
 * 课程管理
 *****************/

// 导入请求公用方法
import { request } from "../../utils/axiosFun";

export const fetchSeriesList = (query) => {
  return request("post", "/api/mgr/course/seriesList", query);
};

export const saveSeriesInfo = (data) => {
  return request("post", "/api/mgr/course/saveSeries", data);
};

export const fetchList = (query) => {
  return request("post", "/api/mgr/course/list", query);
};
export const saveStep1 = (obj) => {
  return request("post", "/api/mgr/course/saveStep1", obj);
};
export const saveStep2 = (chaperList) => {
  return request("post", "/api/mgr/course/saveStep2", chaperList);
};
export const getDetail = (id) => {
  return request("get", "/api/mgr/course/" + id, {});
};
export const modifyStatus = (obj) => {
  return request("post", "/api/mgr/course/modifyStatus", obj);
};
export const fetchAliyunAuth = () => {
  return request("get", "/api/aliyun/mgr/videoConfig", {});
};

export const fetchAliyunPolicy = (data) => {
  return request(
    "get",
    `/api/aliyun/mgr/videoUploadPolicy?fileName=${data.fileName}&title=${data.title}`,
    {}
  );
};

export const refreshAliyunPolicy = (videoId) => {
  return request(
    "get",
    `/api/aliyun/mgr/refreshVideoUploadPolicy?videoId=${videoId}`,
    {}
  );
};

export const fetchVideoInfo = (videoId) => {
  return request("get", `/api/mgr/course/videoInfo/${videoId}`);
};

export const saveCourse = (obj) => {
  return request("post", "/api/mgr/course/save", obj);
};

