/******************
 * 角色管理
 *****************/

// 导入请求公用方法
import {
    request
} from '../../utils/axiosFun';

export function fetchList(query) {
    return request('post', '/api/sys/role/list', query)
}

export function getRoleList() {
    return request('get', '/api/sys/role/select', {})
}

export function getObj(id) {
    return request('get', '/admin/role/' + id, {})
}

export function addObj(obj) {
    return request('post', '/api/sys/role/save', obj)
}

export function putObj(obj) {
    return request('post', '/api/sys/role/update', obj)
}

export function delObj(ids) {
    return request('post', '/api/sys/role/delete', ids)
}

export function permissionUpd(roleId, menuIds) {
    return request('post', '/api/sys/role/menu/save', {
        roleId: roleId,
        menuIds: menuIds
    })
}

export function fetchRoleMenuIds(roleId) {
    return request('get', '/api/sys/role/menuIds/' + roleId)
}