/******************
 * 用户管理
 *****************/

// 导入请求公用方法
import {
    request
} from '../../utils/axiosFun';

export const fetchList = (query) => {
    return request('post', '/api/sys/user/list', query, "F")
}

export const addObj = (obj) => {
    return request('post', '/api/sys/user/save', obj)
}

export const delObj = (ids) => {
    return request('post', '/api/sys/user/delete', ids)
}

export const putObj = (obj) => {
    return request('post', '/api/sys/user/update', obj)
}
export const getObj = (id) => {
    return request('get','/api/sys/user/info/' + id)
}
export const getCurrentInfo = () => {
    return request('get','/api/sys/user/info',{})
}
export const changePassword = (obj) => {
    return request('post','/api/sys/user/password',obj)
}