// 导入请求公用方法
import { request } from "../../utils/axiosFun";

export const saveSwiper = (obj) => {
  return request("post", "/api/mgr/swiperConfig/save", obj);
};

export const fetchAllSwiper = () => {
  return request("get", "/api/mgr/swiperConfig", {});
};

export const fetchHomeTags = () => {
  return request("get", "/api/mgr/mainPageTagConfig", {});
};

export const fetchAvaliHomeTags = (data) => {
  return request("post", "/api/mgr/mainPageTagConfig/tags", {data});
};

export const addHomeTag = (tag) => {
  return request("post", "/api/mgr/mainPageTagConfig/add", tag);
};

export const removeHomeTag = (tagId) => {
  return request("get", `/api/mgr/mainPageTagConfig/delete/${tagId}`, {});
};

export const fetchRecVideos = () => {
  return request("get", `/api/mgr/recommendConfig/list`, {});
};

export const fetchAvailRecVideos = (data) => {
  return request("post", `/api/mgr/recommendConfig/select`, {data});
};

export const addHomeRecVideos = (data) => {
  return request("post", `/api/mgr/recommendConfig/add`, data);
};

export const removeHomeRecVideos = (id) => {
  return request("get", `/api/mgr/recommendConfig/delete/${id}`, {});
};

