import Vue from 'vue'
import VueRouter from 'vue-router'

Vue.use(VueRouter)

const routes = [{
  path: '/login',
  name: '登录页',
  component: () =>
    import( /* webpackChunkName: "page" */ '@/views/login'),
  meta: {
    requireAuth: false,
  },
}, {
  path: '/',
  name: '布局页',
  component: () =>
    import( /* webpackChunkName: "page" */ '@/views/index'),
  meta: {
    requireAuth: true,
  },
  children: [{
    path: 'index',
    name: '首页',
    component: () =>
      import( /* webpackChunkName: "page" */ '@/views/wel'),
    meta: {
      requireAuth: true,
    }
  },
  {
    path: "/userinfo",
    name: "用户信息",
    component: () => 
      import('@/views/admin/user/info.vue'),
    meta: {
      requireAuth: true,
    }
  },
  ]
},
{
  path: '/edu',
  name: 'deu',
  component: () => import ('@/views/index'),
  children: [
    {
      path: 'biz/course/detail',
      name: '课程详情',
      component: () => import('@/views/biz/course/detail')
    }
  ]
},
{
  path: '/edu',
  name: 'qaDetail',
  component: () => import ('@/views/index'),
  children: [
    {
      path: 'biz/qa/detail',
      name: '问答记录',
      component: () => import('@/views/biz/qa/detail')
    }
  ]
},
{
  path: '/edu',
  name: 'qa',
  component: () => import ('@/views/index'),
  children: [
    {
      path: 'biz/qa/index',
      name: '课程提问',
      component: () => import('@/views/biz/qa/index')
    }
  ]
}

]

const router = new VueRouter({
  // 页面刷新白屏问题
  // mode: 'history',
  base: process.env.BASE_URL,
  routes
})

export default router