/**
 * 配置该文件可以参考:
 * https://cli.vuejs.org/zh/config/#%E7%9B%AE%E6%A0%87%E6%B5%8F%E8%A7%88%E5%99%A8
 *
 */
const url = 'http://edu.qkdata.com:10081'
// const url = 'http://localhost:9090'

// 基础路径，发布前修改这里,当前配置打包出来的资源都是相对路径
let publicPath = '/admin'
module.exports = {
  configureWebpack: {
    externals: {
      "BMap": "BMap"
    }
  },
  publicPath: publicPath,
  // eslint校验
  lintOnSave: false,
  productionSourceMap: false,
  // 配置转发代理
  devServer: {
    port: 8081,
    proxy: {
      '/api': {
        target: url,
        changeOrigin: true,
        ws: true,
        pathRewrite: {
          '^/api': '/online-edu-backend/api'
        }
      }
    }
  }
}
